<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AppData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class AppDataController extends Controller
{

    public function index(Request $request)
    {
        $appData = AppData::first();
        //check if additional gateway is enabled
        // if (env('ADDITIONAL_GATEWAY_ENABLED')) {
        //     $appData['payment_method'] = env('ADDITIONAL_GATEWAY_NAME');
        // }
        $appData['payment_url'] = env('APP_URL') . '/payment/';
        // $appData['slider_url'] = 'https://google.com';
        $appData['charts_url'] = env('APP_URL') . '/charts/';
        $appData['homepage_image_url'] = env('APP_URL') . $appData->homepage_image_url;
        $appData['otp_system_removed'] = env('OTP_SYSTEM_REMOVE', 0);
        $appData->invite_bonus = $appData->invite_bonus_1st_time;
        if ($appData->payment_method == 'pay_from_upi') {
            $appData->payment_method = 'direct_upi';
        }


        $token = $request->bearerToken();
        $message = "Done";

        if (!blank($token)) {
            $token_user = \Laravel\Sanctum\PersonalAccessToken::findToken($token);
            if ($token_user === NULL) {
                $data = compact('appData');
                return response()->success($message, $data);
            }

            $user = $token_user->tokenable;

            if (blank($user)) {
                $data = compact('appData');
                return response()->success($message, $data);
            }
            $data = compact('appData', 'user');
            return response()->success($message, $data);
        }
        $data = compact('appData');
        return response()->success($message, $data);
    }
}
