<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AppData;
use App\Models\Otp;
use App\Models\User;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class OtpController extends Controller
{

    function send(Request $request)
    {
        Log::info('Sending OTP SMS');

        $user = User::where('phone', $request->phone)->first();
        if (!$user) {
            return response()->failed('User not found');
        }
        $phoneNumber = $user->phone;
        $otp = rand(1000, 9999);
        $message = $otp;
        // $message = "Your OTP is: " . $otp;
        try {
            $this->sendOtpSms($message, $phoneNumber);
            $user->otps()->create([
                'otp' => $otp,
                'created_at' => now(),
            ]);
        } catch (Exception $e) {
            return $e;
        }

        return response()->success('OTP has been sent successfully', compact('otp'));
    }
    
    public static function sendOtpSms($otp_to_send, $phoneNumber)
    {
        Log::info('Sending OTP SMS otp is ' . $otp_to_send);
        $sms_api_key = AppData::pluck('sms_api_key')->first();
        if (filled($sms_api_key)) {

            $user = User::where('phone', $phoneNumber)->first();
            if (!$user) {
                return response()->failed('User not found');
            }


            $client = new Client();
            $url = "https://meraotp.com/api/sms";
            $fields = [
                "api_key" => $sms_api_key,
                "sms_type" => "otp",
                "mobile_number" => $phoneNumber,
                "message" => $otp_to_send,
            ];

            try {
                $response = $client->post($url, [
                    'headers' => [
                        'Content-Type' => 'application/json',
                        "Authorization" => $sms_api_key,
                    ],
                    'json' => $fields
                ]);

                Log::info("Response : ");
                Log::info($response->getBody()->getContents());
            } catch (\Throwable $th) {
                Log::error('Error sending OTP SMS ' . $th->getMessage());
            }
        }
    }

    public static function verifyMeraOtp($otp, $phoneNumber)
    {
        if (filled($otp)) {
            $client = new Client();
            $url = "https://meraotp.com/api/sms-validate";
            $fields = [
                "mobile_number" => $phoneNumber,
                "otp" => $otp,
            ];

            try {
                $response = $client->post($url, [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $fields
                ]);

                // Convert response to string and decode JSON
                $responseBody = (string) $response->getBody();
                $responseData = json_decode($responseBody, true); // Convert to array
                return $responseData['success'] ?? false;
            } catch (\Throwable $th) {
                Log::error('Error sending OTP SMS ' . $th->getMessage());
                return false;
            }
        }
    }

    // public function sendOtpSms($message, $phoneNumber)
    // {
    //     Log::info('Sending OTP SMS otp is ' . $message);
    //     $sms_api_key = AppData::pluck('sms_api_key')->first();
    //     if (filled($sms_api_key)) {

    //         $client = new Client();
    //         $url = "https://www.fast2sms.com/dev/bulkV2";
    //         $fields = [
    //             // "route" => "p",
    //             "route" => "otp",
    //             // "message" => $message,
    //             "variables_values" => $message,
    //             "language" => "english",
    //             "flash" => 0,
    //             "numbers" => $phoneNumber,
    //         ];
    //         try {
    //             $client->post($url, [
    //                 'headers' => [
    //                     'Content-Type' => 'application/json',
    //                     "Authorization" => $sms_api_key,
    //                 ],
    //                 'json' => $fields
    //             ]);
    //         } catch (\Throwable $th) {
    //             //throw $th;
    //         }
    //     }
    // }
}
