<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Dashboard\DepositHistoryController;
use App\Models\AppData;
use App\Models\DepositHistory;
use App\Models\Transaction;
use App\Models\UpiTransaction;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class TransactionController extends Controller
{
    
    private function deductBalance(Request $request)
    {
        $appData = AppData::find(1);
        if ($appData->payfromupi_api_key === NULL) {
            return;
        }

        $fields = [
            'amount' => $request->amount,
        ];


        $http_request = Http::withHeaders([
            "Content-Type" => "application/json",
        ])
            ->withToken($appData->payfromupi_api_key)
            ->timeout(60)
            ->post("https://payfromupi.com/api/deduct-balance", $fields);
        $response = $http_request->json();

        Log::error($response);
    }
    
    public function AddPayment(Request $request)
    {
        Log::info($request->all());

        $request->validate([
            'amount' => 'required|numeric',
        ]);
        //add amount in user wallet balance and insert in transctio historuy
        /** @var User $user  */
        $user = Auth::user();

        $auto_approval = env('AUTOMATIC_PAYMENT_APPROVAL', false);
        if (isset($request->pay_status) && $auto_approval) {
            $pay_status = strtolower($request->pay_status);
            // if (Str::contains($pay_status, 'bokax')) {
            if (Str::contains($pay_status, 'success')) {
                //deduct balance from payfromupi
                $this->deductBalance($request);
                $prev_balance = $user->balance;
                $user->balance = $user->balance + $request->amount;
                $user->update();

                $user->transactions()->create([
                    "previous_amount" => $prev_balance,
                    "amount" => $request->amount,
                    "current_amount" => $user->balance + $request->amount,
                    "type" => "recharge",
                    "details" => "Direct UPI, Deposit ($request->amount) Successful"
                ]);

                $submit_utr = new DepositHistory();
                $submit_utr->user_id = $user->id;
                $submit_utr->utr = 'DIRECT_UPI';
                $submit_utr->amount = $request->amount;
                $submit_utr->status = "success";
                $submit_utr->transaction_id = Str::random(12);
                $submit_utr->save();

                $otherController = new DepositHistoryController();
                $otherController->giveInviteBonusToUser($user, $submit_utr);
            }
        } else {
            $submit_utr = new DepositHistory();
            $submit_utr->user_id = $user->id;
            $submit_utr->utr = 'DIRECT_UPI';
            $submit_utr->amount = $request->amount;
            $submit_utr->status = "pending";
            $submit_utr->transaction_id = Str::random(12);
            $submit_utr->save();
        }

        $user->refresh();
        $balance_left = $user->balance;

        if (isset($request->pay_status) && Str::contains($pay_status, 'success'))
            $message = "Payment Successfull, Balance Has Been Added!";
        else if (isset($request->pay_status) && Str::contains($pay_status, 'success'))
            $message = "Payment Failed!, No Success Response Found.";
        else $message = "Please Wait for Approval!";
        return response()->success($message, compact('balance_left'));
    }
    
    // public function AddPayment(Request $request)
    // {
    //     $request->validate([
    //         'amount' => 'required|numeric',
    //     ]);
    //     //add amount in user wallet balance and insert in transctio historuy
    //     /** @var User $user  */
    //     $user = Auth::user();
    //     // $prev_balance = $user->balance;
    //     // $user->balance = $user->balance + $request->amount;
    //     // $user->update();

    //     // $user->transactions()->create([
    //     //     "previous_amount" => $prev_balance,
    //     //     "amount" => $request->amount,
    //     //     "current_amount" => $user->balance + $request->amount,
    //     //     "type" => "recharge",
    //     //     "details" => "Direct UPI, Deposit ($request->amount) Successful"
    //     // ]);

    //     $submit_utr = new DepositHistory();
    //     $submit_utr->user_id = $user->id;
    //     $submit_utr->utr = 'DIRECT_UPI';
    //     $submit_utr->amount = $request->amount;
    //     $submit_utr->status = "pending";
    //     $submit_utr->transaction_id = Str::random(12);
    //     $submit_utr->save();

    //     $balance_left = $user->balance;
    //     // $message = "Balance Added! Congratulations!";
    //     $message = "Please Wait for Approval!";
    //     return response()->success($message, compact('balance_left'));
    // }

    function generateRandomString($length = 10)
    {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function SubmitGatewayPayment(Request $request)
    {
        Log::info('SubmitGatewayPayment');
        Log::info($request->all());
        if (!isset($request->client_txn_id)) {
            Log::info('Transaction ID is required');
            return response()->failed('Transaction ID is required');
        }

        $amount = $request->amount;
        $client_txn_id  = $request->client_txn_id;
        $customer_email = $request->customer_email;
        $customer_mobile = $request->customer_mobile;
        $customer_name = $request->customer_name;
        $customer_vpa = $request->customer_vpa;
        $upi_txn_id = $request->upi_txn_id;

        $transactino_check = UpiTransaction::where('client_txn_id', $client_txn_id)
            ->first();
        if ($transactino_check === NULL) {
            return 'Transaction Not Found';
        }

        if ($request->status != 'success') {
            return 'Transaction Failed';
        }

        $user = User::where('phone', $customer_mobile)
            ->first();
        if ($user === NULL) {
            return response()->failed('User Not Found');
        }
        $user->balance = $user->balance + $amount;
        $user->update();

        $user->transactions()->create([
            "previous_amount" => $user->balance,
            "amount" => $amount,
            "current_amount" => $user->balance + $amount,
            "type" => "recharge",
            "details" => "Gatway, Deposit ($amount) Successful"
        ]);

        $submit_utr = new DepositHistory();
        $submit_utr->user_id = $user->id;
        $submit_utr->utr = 'ONLINE_PAYMENT';
        $submit_utr->amount = $amount;
        $submit_utr->status = "success";
        $submit_utr->transaction_id = Str::random(12);
        $submit_utr->save();

        return 'Transaction Done';
    }
    
    public function SubmitPayFromUpiPayment(Request $request)
    {
        Log::info('SubmitPayFromUpiPayment');
        Log::info($request->all());
        if (!isset($request->txn_id)) {
            return response()->failed('Transaction ID is required');
        }

        $amount = $request->amount;
        $txn_id  = $request->txn_id;
        $user_name = $request->user_name;
        $user_mobile = $request->user_mobile;
        $user_email = $request->user_email;

        $transactino_check = UpiTransaction::where('client_txn_id', $txn_id)
            ->first();
        if ($transactino_check === NULL) {
            return 'Transaction Not Found';
        }

        if ($request->status != 'completed') {
            return 'Transaction Failed';
        }

        $user = User::where('phone', $user_mobile)
            ->first();
        if ($user === NULL) {
            return response()->failed('User Not Found');
        }
        $user->balance = $user->balance + $amount;
        $user->update();

        $user->transactions()->create([
            "previous_amount" => $user->balance,
            "amount" => $amount,
            "current_amount" => $user->balance + $amount,
            "type" => "recharge",
            "details" => "PayFromUPI, Deposit ($amount) Successful"
        ]);

        $submit_utr = new DepositHistory();
        $submit_utr->user_id = $user->id;
        $submit_utr->utr = 'ONLINE_PAYMENT_PAYFROMUPI';
        $submit_utr->amount = $amount;
        $submit_utr->status = "success";
        $submit_utr->transaction_id = Str::random(12);
        $submit_utr->save();

        // $otherController = new DepositHistoryController();
        // $otherController->giveInviteBonusToUser($user, $submit_utr);
        // $otherController->giveBonusToSelf($user, $submit_utr);

        return 'Transaction Done';
    }
    
    public function RedirectUrlPayFromUpi(Request $request)
    {
        Log::info('RedirectUrlPayFromUpi');
        $request->validate([
            'amount' => 'required|numeric',
        ]);

        $customer_name = Auth::user()->name;
        $customer_email = Auth::user()->phone . '@gmail.com';
        $customer_mobile = Auth::user()->phone;

        $appData = AppData::find(1);
        if ($appData->payfromupi_api_key === NULL) {
            return response()->failed('API Key Not Found!');
        }

        $fields = [
            'type' => 'any',
            'user_mobile' => $customer_mobile,
            'user_name' => $customer_name,
            'user_email' => $customer_email,
            // 'redirect_url' => "http://exitme",
            'amount' => $request->amount,
        ];


        $http_request = Http::withHeaders([
            "Content-Type" => "application/json",
        ])
            ->withToken($appData->payfromupi_api_key)
            ->timeout(60)
            ->post("https://payfromupi.com/api/transactions/create", $fields);
        $response = $http_request->json();

        Log::error($response);

        if (!$http_request->ok()) {
            $message = "Something went wrong!";
            return response()->failed($message);
        } else {

            if (!$response['success']) {
                Log::error('error');
                $message = $response["message"];
                return response()->failed($message);
            }

            $payment_url = $response["data"]["paymentLink"];
            $txnId = $response["data"]["txnId"];
            $qyeryUrl = $response["data"]["qyeryUrl"];

            $upi_trans = new UpiTransaction();
            $upi_trans->user_id = Auth::user()->id;
            $upi_trans->client_txn_id = $txnId;
            $upi_trans->save();

            return response()->success("Data Sent!", compact('payment_url', 'txnId', 'qyeryUrl'));
        }
    }

    public function RedirectUrl(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric',
        ]);

        $customer_name = Auth::user()->name;
        $customer_email = Auth::user()->phone . '@gmail.com';
        $customer_mobile = Auth::user()->phone;
        $client_txn_id = $this->generateRandomString(9);
        $upi_gateway_api = AppData::find(1)->upi_gateway_key;

        $upi_trans = new UpiTransaction();
        $upi_trans->user_id = Auth::user()->id;
        $upi_trans->client_txn_id = $client_txn_id;
        $upi_trans->save();

        $fields = [
            "key" => $upi_gateway_api,
            "client_txn_id" => $client_txn_id,
            "amount" => $request->amount,
            "p_info" => env('APP_NAME') . " App Payment",
            "customer_name" => $customer_name,
            "customer_email" => $customer_email,
            "customer_mobile" => $customer_mobile,
            "redirect_url" => env('APP_URL') . "exit",
            "udf1" => "user defined field 1",
            "udf2" => "user defined field 2",
            "udf3" => "user defined field 3",
        ];
        $http_request = Http::withHeaders([
            "Content-Type" => "application/json",
        ])->post("https://merchant.upigateway.com/api/create_order", $fields);
        $response = $http_request->json();

        Log::error($response);
        if (!$http_request->ok()) {
            $message = "Something went wrong!";
            return response()->failed($message);
        } else {

            if (!$response['status']) {
                $message = $response['msg'];
                return response()->failed($message);
            }

            $payment_url = $response["data"]["payment_url"];
            return response()->success("Data Sent!", compact('payment_url'));
        }
    }

    public function getTransactions(Request $request)
    {
        $request->validate([
            'page' => 'required|numeric',
        ]);
        $user = Auth::user();
        $transactions = Transaction::where('user_id', $user->id)->latest()->paginate(10, ['*'], 'transactions', $request->page);
        return response()->success("Data Sent!", compact('transactions'));
    }
}
