<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AppData;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;

class UserController extends Controller
{
    public function changeNotification(Request $request)
    {
        $request->validate([
            'type' => ['required', Rule::in(['general', 'startLine', 'desawar'])],
        ]);
        $type = match ($request->type) {
            "general" => "general_noti",
            "startLine" => "startline_noti",
            "desawar" => "desawar_noti",
        };
        /** @var User $user */
        $user = Auth::user();
        $user->$type = !$user->$type;
        $user->save();
        return response()->success('Notification status changed!', NULL);
    }

    public function withdrawBalance(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric',
            'withdraw_mode' => 'required|in:bank,upi,gpay,paytm,phonepe',
        ]);
        /** @var User $user */
        $user = Auth::user();

        if ($user->withdrawDetails == NULL) {
            $message = "Please Add Withdraw Details First";
            return response()->failed($message);
        }

        if ($request->withdraw_mode == 'bank' && $user->withdrawDetails->account_number == NULL) {
            $message = "Please Add Bank Details First";
            return response()->failed($message);
        }
        if ($request->withdraw_mode == 'upi' && $user->withdrawDetails->upi_id == NULL) {
            $message = "Please Add UPI Details First";
            return response()->failed($message);
        }

        if ($user->balance < $request->amount) {
            $message = "Balance is insufficient";
            return response()->failed($message);
        }

        $appData = AppData::first();
        //carbon check if time is between two times
        $now = now();
        $withdraw_open_time = Carbon::parse($appData->withdraw_open_time);
        $withdraw_close_time = Carbon::parse($appData->withdraw_close_time);
        if (!$now->between($withdraw_open_time, $withdraw_close_time)) {
            $message = "Withdraw is not available now, Please Withdraw between " . $withdraw_open_time->format('h:i A') . " to " . $withdraw_close_time->format('h:i A') . "";
            return response()->failed($message);
        }

        $user->balance = $user->balance - $request->amount;
        $user->save();
        $user->withdrawHistory()->create([
            'amount' => $request->amount,
            'withdraw_mode' => $request->withdraw_mode,
            'status' => 'pending',
            'transaction_id' => Str::random(12)
        ]);
        $user->transactions()->create([
            'previous_amount' => $user->balance,
            'amount' => $request->amount,
            'current_amount' =>  $user->balance - $request->amount,
            'type' => "withdraw",
            "details" => "Withdraw a balance"
        ]);
        $balance_left = $user->balance;
        return response()->success('Withdraw request sent!', compact('balance_left'));
    }

    public function getReferralDetails()
    {
        $user = User::with('referralUsers')->find(auth()->id());
        $referralUsers = $user->referralUsers;

        $total_earned = count($referralUsers) * AppData::first()->invite_bonus;
        $total_invited = count($referralUsers);

        return response()->success("Data Sent!", compact('total_earned', 'total_invited', 'referralUsers'));
    }
}
