<?php

namespace App\Http\Controllers\Dashboard;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{

    //construct fucntoin
    public function __construct()
    {
        new verify_payments();
    }

    public function index()
    {
        if (Auth::check()) {
            return redirect('/dashboard');
        }
        return view('login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'phone' => 'required|string',
            'password' => ['required'],
        ]);
        // Attempt to log the user in
        $credentials = $request->only('phone', 'password');
        if (Auth::attempt($credentials)) {
            $user = Auth::user();
            if ($user->role === 'admin' || $user->role == "sub-admin") {
                // Authentication passed and user is an admin...
                return redirect()->intended('/dashboard');
            } else {
                // User is not an admin, so logout and redirect back with an error message
                Auth::logout();
                return back()->withErrors([
                    'credentials' => 'You do not have permission to access the dashboard.',
                ]);
            }
        }

        // If authentication fails, redirect back with an error message
        return back()->withErrors([
            'credentials' => 'The provided credentials do not match our records.',
        ]);
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/login');
    }

    // Change Password

    public function changePasswordIndex()
    {
        return view("dashboard.change-password.index");
    }

    public function changePasswordStore(Request $request)
    {
        $request->validate([
            "password" => 'required|confirmed',
        ]);

        $user = User::findOrFail(auth()->id());
        $user->password = Hash::make($request->password);
        $user->save();
        return back()->with("success", "Password has been changed.");
    }
}
