<?php

namespace App\Http\Controllers\Dashboard;


use App\Models\DepositHistory;
use App\Http\Controllers\Controller;
use App\Models\AppData;
use App\Models\User;
use App\Notifications\BonusWonNotification;
use App\Notifications\DepositRequestAcceptNotification;
use App\Notifications\DepositRequestRejectNotification;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class DepositHistoryController extends Controller
{
    public function index()
    {
        $depositHistories  = DepositHistory::with('user')->latest()->paginate(25);
        return view('dashboard.deposit-history.index', compact('depositHistories'));
    }
    
    public function giveInviteBonusToUser($user, $deposit)
    {
        //give bonus to the refferal user
        $appData = AppData::first();
        $invite_bonus_1st_time = $appData->invite_bonus_1st_time;
        $invite_bonus_2nd_time = $appData->invite_bonus_2nd_time;
        $referrer_user = $user->referredUser;
        $invite_bonus = $user->depositHistory()->count() == 1 ? $invite_bonus_1st_time : $invite_bonus_2nd_time;
        //invite_bonus percentage of the deposit amount
        $amount_to_give = $invite_bonus == 0 ? 0 : ($deposit->amount * $invite_bonus) / 100;


        if ($appData->invite_system_enable && $referrer_user && $amount_to_give > 0) {
            $balance_before = $referrer_user->balance;
            $referrer_user->balance = $referrer_user->balance + $amount_to_give ?? 0;
            $referrer_user->save();
            $referrer_user->transactions()->create([
                'previous_amount' => $balance_before,
                'amount' => $amount_to_give,
                'current_amount' => $referrer_user->balance,
                "type" => "recharge",
                "details" => "You won ($amount_to_give) in bonus"
            ]);
            $referrer_user->notify(new BonusWonNotification($amount_to_give, $referrer_user->fcm));
        }
        return;
    }

    public function acceptRequest($id)
    {
        $deposit = DepositHistory::findOrFail($id);
        //if already success then return error
        if ($deposit->status == "success") {
            return back()->with('error', 'Request has already been accepted');
        }
        $deposit->status = "success";
        $deposit->save();
        $user = User::with('referredUser')->findOrFail($deposit->user->id);
        $firstDeposit =  $user->depositHistory()->orderBy('created_at', 'asc')->first();
        $appData = AppData::first();
        //On 1st recharge, give amount to the refferal user
        if ($deposit->id == $firstDeposit->id && $appData->invite_system_enable) {
            $refferredUser = $user->referredUser;
            if ($refferredUser) {
                $invite_bonus = $appData->invite_bonus;
                $balance_before = $refferredUser->balance;
                $refferredUser->balance = $refferredUser->balance + $invite_bonus ?? 0;
                $refferredUser->save();
                $refferredUser->transactions()->create([
                    'previous_amount' => $balance_before,
                    'amount' => $invite_bonus,
                    'current_amount' => $refferredUser->balance,
                    "type" => "recharge",
                    "details" => "You won ($deposit->amount) in bonus"
                ]);
                $refferredUser->notify(new BonusWonNotification($deposit->amount, $refferredUser->fcm));
            }
        }
        $balance_before = $user->balance;
        $user->balance = $user->balance + $deposit->amount;
        $user->save();
        $user->transactions()->create([
            'previous_amount' => $balance_before,
            'amount' => $deposit->amount,
            'current_amount' => $user->balance,
            "type" => "recharge",
            "details" => "Deposit ($deposit->amount) Accepted"
        ]);
        $user->notify(new DepositRequestAcceptNotification($deposit->amount, $user->fcm));
        return back()->with('success', 'Request has been accepted');
    }

    public function rejectRequest($id)
    {
        $deposit = DepositHistory::with("user")->findOrFail($id);
        //if already failed then return error
        if ($deposit->status == "failed") {
            return back()->with('error', 'Request has already been rejected');
        }
        $deposit->status = "failed";
        $deposit->save();
        $user = User::findOrFail($deposit->user->id);
        $user->notify(new DepositRequestRejectNotification($deposit->amount, $user->fcm));
        return back()->with('success', 'Request has been rejected');
    }
}
