<?php

namespace App\Http\Controllers\Dashboard;


use App\Models\DesawarRecord;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DesawarRecordController extends Controller
{
    public function index(Request $request)
    {
        if ($request->has('searchValue')) {
            $searchValue = $request->searchValue;
            $desawarRecords = DesawarRecord::with(['market', 'user'])
                ->whereHas('user', function ($query) use ($searchValue) {
                    $query->where('name', 'LIKE', '%' . $searchValue . '%')
                        ->orWhere('phone', 'LIKE', '%' . $searchValue . '%');
                })->latest()->paginate(250);
            return view('dashboard.desawar-markets.records', compact('desawarRecords', 'searchValue'));
        }

        $desawarRecords = DesawarRecord::with('market')->latest()->paginate(25);
        return view('dashboard.desawar-markets.records', compact('desawarRecords'));
    }

    public function winHistory(Request $request)
    {
        if ($request->has('searchValue')) {
            $searchValue = $request->searchValue;
            $winHistory = DesawarRecord::with(['user', 'market', 'gameType'])
                ->where('status', 'success')
                ->whereHas('user', function ($query) use ($searchValue) {
                    $query->where('name', 'LIKE', '%' . $searchValue . '%')
                        ->orWhere('phone', 'LIKE', '%' . $searchValue . '%');
                })->latest()->paginate(250);
            return view('dashboard.desawar-markets.win-history', compact('winHistory', 'searchValue'));
        }

        $winHistory = DesawarRecord::with(['user', 'market', 'gameType'])->where('status', 'success')->latest()->paginate(25);
        return view('dashboard.desawar-markets.win-history', compact('winHistory'));
    }
}
