<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Market;
use App\Models\MarketRecord;
use App\Services\PanaNumbersService;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class MarketWinPredictionController extends Controller
{
    public function index()
    {
        $panaNumbersService = new PanaNumbersService();
        $panaNumbers = $panaNumbersService->getPanaNumbersList();
        $markets = Market::latest()->get();
        return view("dashboard.markets.prediction-results", compact("markets", "panaNumbers"));
    }

    public function getPrediction(Request $request)
    {

        $win_numbers = [
            (int)$request->query('pana'),
            (int)$request->query('digit')
        ];
        $winning_amount = 0;
        $bidding_amount = 0;
        $results = collect();
        $records = MarketRecord::with(["market", "gameType", "user"])
            ->where("session", $request->query('session'))
            ->where("market_id", $request->query('market'))
            ->whereDate("date", $request->query('date'))
            ->get();

        if (filled($records)) {
            foreach ($records as $record) {
                $recordData = collect();
                if (in_array($record->number, $win_numbers)) {
                    $recordData->put("id", $record->id);
                    $recordData->put("market_name", $record->market->name);
                    $recordData->put("user_name", $record->user->name);
                    $recordData->put("amount", $record->amount);
                    $recordData->put("number", $record->number);
                    $recordData->put("win_amount", $record->amount * $record->gameType->multiply_by);
                    $winning_amount += $record->amount * $record->gameType->multiply_by;
                    $bidding_amount += $record->amount;
                    $recordData->put("created_at", $record->created_at);
                    $results->push($recordData);
                }
            }
        }
        $view  = view(
            "dashboard.markets.prediction-get-results",
            compact('results', 'bidding_amount', 'winning_amount')
        )->render();
        return response()->json([
            'view' => $view
        ]);
    }

    public function updatePredictionBid(Request $request)
    {
        $request->validate([
            'amount' => 'required',
            'game_id' => 'required'
        ]);
        MarketRecord::where(['id' => $request->game_id])->update([
            'amount' => $request->amount
        ]);
        return response()->json(['status' => 'success']);
    }
}
