<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\WithdrawHistory;
use App\Http\Controllers\Controller;
use App\Notifications\WithdrawRequestAcceptNotification;
use App\Notifications\WithdrawRequestRejectNotification;
use Illuminate\Http\Request;

class WithdrawHistoryController extends Controller
{
    public function index(Request $request)
    {
        if ($request->has('searchValue')) {
            $searchValue = $request->searchValue;
            $withdrawHistories = WithdrawHistory::with('user')
                ->whereHas('user', function ($query) use ($searchValue) {
                    $query->where('name', 'LIKE', '%' . $searchValue . '%')
                        ->orWhere('phone', 'LIKE', '%' . $searchValue . '%');
                })->latest()->paginate(250);
            return view('dashboard.withdraw-history.index', compact('withdrawHistories', 'searchValue'));
        }
        $withdrawHistories  = WithdrawHistory::latest()->paginate(25);
        return view('dashboard.withdraw-history.index', compact('withdrawHistories'));
    }

    public function acceptRequest($id)
    {
        $withdraw = WithdrawHistory::findOrFail($id);
        if ($withdraw->status == "success") {
            return back()->with('error', 'Request has already been accepted');
        }
        $withdraw->status = "success";
        $withdraw->save();
        $user = $withdraw->user;
        $user->transactions()->create([
            'previous_amount' => $user->balance,
            'amount' => $withdraw->amount,
            'current_amount' => $withdraw->amount + $user->balance,
            "type" => "withdraw",
            "details" => "Withdraw ($withdraw->amount) Accepted"
        ]);
        $user->notify(new WithdrawRequestAcceptNotification($withdraw->amount, $user->fcm));
        return back()->with('success', 'Request has been accepted');
    }

    public function rejectRequest($id)
    {
        $withdraw = WithdrawHistory::with("user")->findOrFail($id);
        if ($withdraw->status == "failed") {
            return back()->with('error', 'Request has already been rejected');
        }
        $withdraw->status = "failed";
        $withdraw->save();
        $user = $withdraw->user;
        $user->balance += $withdraw->amount;
        $user->save();
        $user->transactions()->create([
            'previous_amount' => $user->balance,
            'amount' => $withdraw->amount,
            'current_amount' => $withdraw->amount + $user->balance,
            "type" => "withdraw",
            "details" => "Withdraw ($withdraw->amount) Rejected"
        ]);
        $user->notify(new WithdrawRequestRejectNotification($withdraw->amount, $user->fcm));
        return back()->with('success', 'Request has been rejected');
    }
}
