<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DesawarMarket extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'api_key_name',
        'previous_day_check',
        'open_time',
        'auto_result',
        'close_time',
        'result_time',
        'disable_game'
    ];

    protected $appends = ['game_on', 'last_result'];

    public function getLastResultAttribute()
    {
        $last_result = $this->results()->latest()->first();
        if ($last_result !== NULL && $last_result->result_date == date('Y-m-d')) {
            return $last_result;
        }
        return NULL;
    }

    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('m/d/Y h:i A');
    }

    public function getOpenTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function getCloseTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function getResultTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function records()
    {
        return  $this->hasMany(DesawarRecord::class);
    }

    public function results()
    {
        return $this->hasMany(DesawarResult::class);
    }

    public function getGameOnAttribute()
    {
        $now = Carbon::now();
        $openTime = Carbon::parse($this->open_time);
        $closeTime = Carbon::parse($this->close_time);

        if (!$now->lte($closeTime)) {
            return false;
        }

        if ($this->disable_game) {
            return false;
        }

        return true;
    }
}
