<?php

namespace App\Services;

use App\Models\Market;
use App\Models\MarketRecord;
use App\Models\User;
use App\Notifications\GameResultNotification;
use App\Notifications\GameWinNotification;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;

class MarketResultSetService
{

    public function setResult($request, $fromApi = false)
    {
        $market = Market::with(['results' => function ($query) use ($request) {
            $query->where('result_date', $request->date)->first();
        }])->findOrFail($request->market);

        $result = $market->results->first();
        if ($market->previous_day_check && $fromApi) {
            $date = Carbon::parse($request->date);
            $date = $date->subDay();
        } else {
            $date = $request->date;
        }
        if (is_null($result)) {

            $market->results()->create([
                "result_date" => $request->date,
                "open_pana" => $request->session == "open" ? $request->pana : null,
                "open_digit" => $request->session == "open" ? $request->digit : null,
                "close_pana" => $request->session == "close" ? $request->pana : null,
                "close_digit" => $request->session == "close" ? $request->digit : null
            ]);

            $win_numbers = [
                (string) $request->pana,
                (string) $request->digit,
            ];

            $this->checkUsersWonOrLost($market->id, $win_numbers, $request->date, $request->session, false);

            return back()->with("success", "Market result created successfully");
        } else {
            $field = $request->session == "open" ? "open" : "close";

            if (!is_null($result->{$field . '_pana'})) {
                return back()->with("error", ucfirst($field) . " pana is already set");
            }

            $result->{$field . '_pana'} = $request->pana;
            $result->{$field . '_digit'} = $request->digit;
            $result->save();

            if ($request->session == "open") {
                $win_numbers = [
                    (string) $request->pana,
                    (string) $request->digit,
                ];
                $bothSession = false;
                if (filled($result->close_pana)) {
                    array_push($win_numbers, (string) $result->close_pana);
                    array_push($win_numbers, (string) $result->close_digit);
                    array_push($win_numbers, (string) ($result->open_digit . $result->close_pana));
                    array_push($win_numbers, (string) ($result->open_digit . $result->close_digit));
                    array_push($win_numbers, (string) ($result->open_pana . $result->close_digit));
                    array_push($win_numbers, (string) ($result->open_pana . $result->close_pana));
                    $bothSession = true;
                }
                $session = $request->session;
                $this->checkUsersWonOrLost($market->id, $win_numbers, $request->date, $session, $bothSession);
                return back()->with("success", "Open pana is set");
            }

            $win_numbers = [(string) $request->pana, (string) $request->digit];

            $bothSession = false;
            if (filled($result->open_pana)) {
                // array_push($win_numbers, (string) $result->open_pana);
                // array_push($win_numbers, (string) $result->open_digit);
                array_push($win_numbers, (string) ($result->open_digit . $result->close_pana));
                array_push($win_numbers, (string) ($result->open_pana . $result->close_digit));
                array_push($win_numbers, (string) ($result->open_digit . $result->close_digit));
                array_push($win_numbers, (string) ($result->open_pana . $result->close_pana));
                $bothSession = true;
            }

            $session = $request->session;

            $this->checkUsersWonOrLost(
                $market->id,
                $win_numbers,
                $request->date,
                $session,
                $bothSession
            );
            return back()->with("success", "Close pana is set");
        }
    }

    // Checking user win or lost
    private function checkUsersWonOrLost($marketId, $win_numbers, $date, $session, $bothSession)
    {
        Log::info('market ' . $marketId);
        $market = Market::find($marketId);
        $records = MarketRecord::with(["market", "gameType", "user"])
            ->where("session", $session)
            ->where("date", $date)
            ->where("market_id", $marketId)
            ->where('status', 'pending')
            ->when($bothSession, function ($query) {
                return $query->Orwhere("session", 'null');
            })
            ->get();
        if (filled($records)) {
            foreach ($records as $record) {
                $user = $record->user;
                if (in_array(strval($record->number), $win_numbers, true)) {
                    //log record number and win numbrs
                    // Log::info("Record number: " . $record->number . " Win numbers: " . json_encode($win_numbers));
                    $record["status"] = "success";
                    $record["win_amount"] = $record->amount * $record->gameType->multiply_by;
                    $user->balance += $record["win_amount"];
                    $user->save();
                    $user->transactions()->create([
                        'previous_amount' =>  $user->balance - $record["win_amount"],
                        'amount' => $record["win_amount"],
                        'current_amount' => $user->balance,
                        "type" => "win",
                        // ( current_time : game_name : game_type : session ) : number
                        "details" => "Win (" . now() . $record->market->name .
                            " :" . $record->gameType->name . ": " . " : $session ) : $record->number"
                    ]);
                    if ($user->general_noti) {
                        $user->notify(new GameWinNotification($record['win_amount'], $user->fcm));
                    }
                } else {
                    $record["status"] = "failed";
                    $record["win_amount"] = 0;
                }
                $record->save();
            }
        }
        $usersFcms = User::where('general_noti', true)->pluck('fcm')->toArray();
        $market->refresh();
        if ($market->last_result !== NULL) {
            $result = $market->last_result->result;
            Log::info('Result found ' . $result);
        } else {
            Log::info('Result not found XXX');
            $result = 'XXX-XX-XXX';
        }
        //FascadeNotification
        Notification::send(NULL, new GameResultNotification($market->name, $result, $usersFcms));
    }
}
